/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.sql;

import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.exceptions.ExceptionsKt;
import org.jetbrains.exposed.sql.ColumnDiff;
import org.jetbrains.exposed.sql.ColumnKt;
import org.jetbrains.exposed.sql.ColumnTypeKt;
import org.jetbrains.exposed.sql.DdlAware;
import org.jetbrains.exposed.sql.Expression;
import org.jetbrains.exposed.sql.ExpressionWithColumnType;
import org.jetbrains.exposed.sql.ForeignKeyConstraint;
import org.jetbrains.exposed.sql.IColumnType;
import org.jetbrains.exposed.sql.QueryBuilder;
import org.jetbrains.exposed.sql.SQLLogKt;
import org.jetbrains.exposed.sql.Table;
import org.jetbrains.exposed.sql.Transaction;
import org.jetbrains.exposed.sql.transactions.TransactionManager;
import org.jetbrains.exposed.sql.vendors.DefaultKt;
import org.jetbrains.exposed.sql.vendors.H2Dialect;
import org.jetbrains.exposed.sql.vendors.SQLiteDialect;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u00022\u00020\u00032\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00000\u0004B\u001f\u0012\u0006\u0010N\u001a\u00020M\u0012\u0006\u0010I\u001a\u00020\n\u0012\u0006\u0010+\u001a\u00020*\u00a2\u0006\u0004\bR\u0010SJ\u001c\u0010\u0007\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\fJ\u001a\u0010\u0013\u001a\u00020\r2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0012H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0019\u001a\u00020\rH\u0000\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016\u00a2\u0006\u0004\b\u001a\u0010\fJ\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\r\u0010\u001f\u001a\u00020\n\u00a2\u0006\u0004\b\u001f\u0010 J\u001f\u0010\"\u001a\n\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u0000\"\b\b\u0001\u0010!*\u00028\u0000\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020$H\u0016\u00a2\u0006\u0004\b'\u0010(J\u000f\u0010)\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b)\u0010 R\u001a\u0010+\u001a\u00020*8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R*\u00100\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010/8\u0000@\u0000X\u0080\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\n0\t8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\fR*\u00109\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u0001088\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u0010:\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R$\u0010@\u001a\u0004\u0018\u00010?8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010A\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0014\u0010F\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bF\u0010\u0018R\u0014\u0010H\u001a\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u0018R\u0017\u0010I\u001a\u00020\n8\u0006\u00a2\u0006\f\n\u0004\bI\u0010J\u001a\u0004\bK\u0010 R\u0017\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00008F\u00a2\u0006\u0006\u001a\u0004\bL\u0010#R\u0017\u0010N\u001a\u00020M8\u0006\u00a2\u0006\f\n\u0004\bN\u0010O\u001a\u0004\bP\u0010Q\u00a8\u0006T"}, d2={"Lorg/jetbrains/exposed/sql/Column;", "T", "Lorg/jetbrains/exposed/sql/ExpressionWithColumnType;", "Lorg/jetbrains/exposed/sql/DdlAware;", "", "other", "", "compareTo", "(Lorg/jetbrains/exposed/sql/Column;)I", "", "", "createStatement", "()Ljava/util/List;", "", "modify", "descriptionDdl", "(Z)Ljava/lang/String;", "dropStatement", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "isOneColumnPK$exposed_core", "()Z", "isOneColumnPK", "modifyStatement", "Lorg/jetbrains/exposed/sql/ColumnDiff;", "columnDiff", "modifyStatements", "(Lorg/jetbrains/exposed/sql/ColumnDiff;)Ljava/util/List;", "nameInDatabaseCase", "()Ljava/lang/String;", "S", "referee", "()Lorg/jetbrains/exposed/sql/Column;", "Lorg/jetbrains/exposed/sql/QueryBuilder;", "queryBuilder", "", "toQueryBuilder", "(Lorg/jetbrains/exposed/sql/QueryBuilder;)V", "toString", "Lorg/jetbrains/exposed/sql/IColumnType;", "columnType", "Lorg/jetbrains/exposed/sql/IColumnType;", "getColumnType", "()Lorg/jetbrains/exposed/sql/IColumnType;", "Lorg/jetbrains/exposed/sql/Expression;", "dbDefaultValue", "Lorg/jetbrains/exposed/sql/Expression;", "getDbDefaultValue$exposed_core", "()Lorg/jetbrains/exposed/sql/Expression;", "setDbDefaultValue$exposed_core", "(Lorg/jetbrains/exposed/sql/Expression;)V", "getDdl", "ddl", "Lkotlin/Function0;", "defaultValueFun", "Lkotlin/jvm/functions/Function0;", "getDefaultValueFun", "()Lkotlin/jvm/functions/Function0;", "setDefaultValueFun", "(Lkotlin/jvm/functions/Function0;)V", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "foreignKey", "Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "getForeignKey", "()Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;", "setForeignKey", "(Lorg/jetbrains/exposed/sql/ForeignKeyConstraint;)V", "isLastColumnInPK", "isPrimaryConstraintWillBeDefined$exposed_core", "isPrimaryConstraintWillBeDefined", "name", "Ljava/lang/String;", "getName", "getReferee", "Lorg/jetbrains/exposed/sql/Table;", "table", "Lorg/jetbrains/exposed/sql/Table;", "getTable", "()Lorg/jetbrains/exposed/sql/Table;", "<init>", "(Lorg/jetbrains/exposed/sql/Table;Ljava/lang/String;Lorg/jetbrains/exposed/sql/IColumnType;)V", "exposed-core"})
public final class Column<T>
extends ExpressionWithColumnType<T>
implements DdlAware,
Comparable<Column<?>> {
    @NotNull
    private final Table table;
    @NotNull
    private final String name;
    @NotNull
    private final IColumnType columnType;
    @Nullable
    private ForeignKeyConstraint foreignKey;
    @Nullable
    private Function0<? extends T> defaultValueFun;
    @Nullable
    private Expression<T> dbDefaultValue;

    public Column(@NotNull Table table, @NotNull String name, @NotNull IColumnType columnType) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)columnType, (String)"columnType");
        this.table = table;
        this.name = name;
        this.columnType = columnType;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public IColumnType getColumnType() {
        return this.columnType;
    }

    @Nullable
    public final ForeignKeyConstraint getForeignKey() {
        return this.foreignKey;
    }

    public final void setForeignKey(@Nullable ForeignKeyConstraint foreignKeyConstraint) {
        this.foreignKey = foreignKeyConstraint;
    }

    @Nullable
    public final Column<?> getReferee() {
        ForeignKeyConstraint foreignKeyConstraint = this.foreignKey;
        return foreignKeyConstraint == null ? null : foreignKeyConstraint.targetOf(this);
    }

    @Nullable
    public final <S extends T> Column<S> referee() {
        Column<?> column = this.getReferee();
        return column instanceof Column ? column : null;
    }

    @Nullable
    public final Function0<T> getDefaultValueFun() {
        return this.defaultValueFun;
    }

    public final void setDefaultValueFun(@Nullable Function0<? extends T> function0) {
        this.defaultValueFun = function0;
    }

    @Nullable
    public final Expression<T> getDbDefaultValue$exposed_core() {
        return this.dbDefaultValue;
    }

    public final void setDbDefaultValue$exposed_core(@Nullable Expression<T> expression) {
        this.dbDefaultValue = expression;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        TransactionManager.Companion.current().fullIdentity$exposed_core(this, queryBuilder);
    }

    @NotNull
    public final List<String> getDdl() {
        return this.createStatement();
    }

    @NotNull
    public final String nameInDatabaseCase() {
        return DefaultKt.inProperCase(this.name);
    }

    private final boolean isLastColumnInPK() {
        Column column;
        Table.PrimaryKey primaryKey = this.table.getPrimaryKey();
        if (primaryKey == null) {
            column = null;
        } else {
            Object[] objectArray = primaryKey.getColumns();
            column = objectArray == null ? null : (Column)ArraysKt.last((Object[])objectArray);
        }
        return Intrinsics.areEqual(column, (Object)this);
    }

    public final boolean isPrimaryConstraintWillBeDefined$exposed_core() {
        return DefaultKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType()) ? false : (this.table.isCustomPKNameDefined$exposed_core() ? this.isLastColumnInPK() : (this.isOneColumnPK$exposed_core() ? false : this.isLastColumnInPK()));
    }

    @Override
    @NotNull
    public List<String> createStatement() {
        String alterTablePrefix = "ALTER TABLE " + TransactionManager.Companion.current().identity(this.table) + " ADD";
        boolean isH2withCustomPKConstraint = DefaultKt.getCurrentDialect() instanceof H2Dialect && this.isLastColumnInPK();
        String columnDefinition = this.isPrimaryConstraintWillBeDefined$exposed_core() && this.isLastColumnInPK() && !isH2withCustomPKConstraint ? this.descriptionDdl(false) + ", ADD " + this.table.primaryKeyConstraint$exposed_core() : (isH2withCustomPKConstraint ? this.descriptionDdl(true) : this.descriptionDdl(false));
        String addConstr = isH2withCustomPKConstraint ? alterTablePrefix + ' ' + this.table.primaryKeyConstraint$exposed_core() : null;
        Object[] objectArray = new String[]{alterTablePrefix + ' ' + columnDefinition, addConstr};
        return CollectionsKt.listOfNotNull((Object[])objectArray);
    }

    @NotNull
    public final List<String> modifyStatements(@NotNull ColumnDiff columnDiff) {
        Intrinsics.checkNotNullParameter((Object)columnDiff, (String)"columnDiff");
        return DefaultKt.getCurrentDialect().modifyColumn(this, columnDiff);
    }

    @Override
    @NotNull
    public List<String> modifyStatement() {
        return DefaultKt.getCurrentDialect().modifyColumn(this, ColumnDiff.Companion.getAllChanged());
    }

    @Override
    @NotNull
    public List<String> dropStatement() {
        Transaction tr = TransactionManager.Companion.current();
        return CollectionsKt.listOf((Object)("ALTER TABLE " + tr.identity(this.table) + " DROP COLUMN " + tr.identity(this)));
    }

    public final boolean isOneColumnPK$exposed_core() {
        Column column;
        Table.PrimaryKey primaryKey = this.table.getPrimaryKey();
        if (primaryKey == null) {
            column = null;
        } else {
            Object[] objectArray = primaryKey.getColumns();
            column = objectArray == null ? null : (Column)ArraysKt.singleOrNull((Object[])objectArray);
        }
        return Intrinsics.areEqual(column, (Object)this);
    }

    @NotNull
    public final String descriptionDdl(boolean modify) {
        boolean bl;
        StringBuilder stringBuilder;
        StringBuilder $this$descriptionDdl_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl2 = false;
        Transaction tr = TransactionManager.Companion.current();
        Column column = this;
        $this$descriptionDdl_u24lambda_u2d0.append(tr.identity(column));
        $this$descriptionDdl_u24lambda_u2d0.append(" ");
        Table.PrimaryKey primaryKey = this.getTable().getPrimaryKey();
        if (primaryKey == null) {
            bl = false;
        } else {
            Object[] objectArray = primaryKey.getColumns();
            bl = objectArray == null ? false : ArraysKt.contains((Object[])objectArray, (Object)column);
        }
        boolean isPKColumn = bl;
        boolean isSQLiteAutoIncColumn = DefaultKt.getCurrentDialect() instanceof SQLiteDialect && ColumnTypeKt.isAutoInc(this.getColumnType());
        if (!isPKColumn && isSQLiteAutoIncColumn) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to primary key column");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && !this.isOneColumnPK$exposed_core()) {
            ExceptionsKt.throwUnsupportedException(tr, "Auto-increment could be applied only to a single column primary key");
            throw new KotlinNothingValueException();
        }
        if (isSQLiteAutoIncColumn && this.getTable().isCustomPKNameDefined$exposed_core()) {
            String rawType = StringsKt.substringBefore$default((String)this.getColumnType().sqlType(), (String)"PRIMARY KEY", null, (int)2, null);
            String string = this.getTable().primaryKeyConstraint$exposed_core();
            Intrinsics.checkNotNull((Object)string);
            String constraintPart = StringsKt.substringBefore$default((String)string, (String)"(", null, (int)2, null);
            $this$descriptionDdl_u24lambda_u2d0.append(rawType + ' ' + constraintPart + " AUTOINCREMENT");
        } else {
            $this$descriptionDdl_u24lambda_u2d0.append(this.getColumnType().sqlType());
        }
        Expression<T> defaultValue = this.getDbDefaultValue$exposed_core();
        if (defaultValue != null) {
            String expressionSQL = DefaultKt.getCurrentDialect().getDataTypeProvider().processForDefaultValue(defaultValue);
            if (!DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
                String clientDefault = this.getDefaultValueFun() != null ? " Expression will be evaluated on the client." : (!this.getColumnType().getNullable() ? " Column will be created with NULL marker." : "");
                SQLLogKt.getExposedLogger().error(DefaultKt.getCurrentDialect().getName() + ' ' + tr.getDb().getVersion() + " doesn't support expression '" + expressionSQL + "' as default value." + clientDefault);
            } else {
                $this$descriptionDdl_u24lambda_u2d0.append(Intrinsics.stringPlus((String)" DEFAULT ", (Object)expressionSQL));
            }
        }
        if (this.getColumnType().getNullable() || defaultValue != null && this.getDefaultValueFun() == null && !DefaultKt.getCurrentDialect().isAllowedAsColumnDefault(defaultValue)) {
            $this$descriptionDdl_u24lambda_u2d0.append(" NULL");
        } else if (!isPKColumn || DefaultKt.getCurrentDialect() instanceof SQLiteDialect && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u2d0.append(" NOT NULL");
        }
        if (!modify && this.isOneColumnPK$exposed_core() && !this.isPrimaryConstraintWillBeDefined$exposed_core() && !isSQLiteAutoIncColumn) {
            $this$descriptionDdl_u24lambda_u2d0.append(" PRIMARY KEY");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    public static /* synthetic */ String descriptionDdl$default(Column column, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return column.descriptionDdl(bl);
    }

    @Override
    public int compareTo(@NotNull Column<?> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return ColumnKt.access$getComparator$p().compare(this, other);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Column)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.table, (Object)((Column)other).table)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Column)other).name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getColumnType(), (Object)((Column)other).getColumnType());
    }

    @Override
    public int hashCode() {
        return this.table.hashCode() * 31 + this.name.hashCode();
    }

    @Override
    @NotNull
    public String toString() {
        return this.table.getClass().getName() + '.' + this.name;
    }
}

